# 📧 Email Setup Guide - Taxi Agadir Airport

## ✅ Your Email Design is Ready!

The beautiful email templates are already implemented in `server/server.js`. Now you just need to configure your email credentials.

---

## 🔧 Setup Steps

### 1. Create `.env` File

Create a file named `.env` in the `server/` directory with the following content:

```env
# Email Configuration for Namecheap
SMTP_HOST=mail.taxiagadirairport.com
SMTP_PORT=587

# Your Email Credentials
EMAIL_USER=info@taxiagadirairport.com
EMAIL_PASS=your_actual_password_here
```

**Important:** Replace `your_actual_password_here` with your actual email password from Namecheap.

---

### 2. Get Your Email Credentials

1. **Login to Namecheap**
2. **Go to cPanel** for your hosting account
3. **Find "Email Accounts"** section
4. **Locate** `info@taxiagadirairport.com`
5. **Get/Reset** the password

**SMTP Settings for Namecheap:**
- **Host:** `mail.taxiagadirairport.com` (or `mail.yourdomain.com`)
- **Port:** `587` (TLS - Recommended) or `465` (SSL)
- **User:** `info@taxiagadirairport.com`
- **Password:** Your email password

---

### 3. Start the Server

```bash
cd server
node server.js
```

The server will start on port 5000 and you'll see:
```
Server is running on port 5000
Email Configuration:
- Host: mail.taxiagadirairport.com
- Port: 587
- User: info@taxiagadirairport.com
```

---

## 🎨 Email Templates Ready

Your server is configured to send **3 types of emails**:

### 1. **Customer Confirmation Email** ✅
**Sent to:** Customer's email  
**When:** Customer submits booking form  
**Design:** Green gradient header with success badge  
**Contains:**
- ✅ Personalized welcome message
- 📋 Complete booking summary
- 📌 Next steps guide
- 💬 WhatsApp contact button
- 📞 All contact information

**Preview:** Open `server/email-templates/customer-confirmation-preview.html` in browser

---

### 2. **Admin Booking Notification** 🚕
**Sent to:** info@taxiagadirairport.com  
**When:** Customer submits booking form  
**Design:** Blue gradient header with urgent badge  
**Contains:**
- 👤 Customer information
- 🚗 Trip details
- ⏰ Action required alert
- 📧 Reply-to set to customer's email

**Preview:** Open `server/email-templates/booking-email-preview.html` in browser

---

### 3. **Contact Form Email** 💬
**Sent to:** info@taxiagadirairport.com  
**When:** Customer submits contact form  
**Design:** Orange gradient header  
**Contains:**
- 👤 Contact information
- 📝 Customer's message
- ⏰ Quick response reminder
- 📧 Reply-to set to customer's email

**Preview:** Open `server/email-templates/contact-email-preview.html` in browser

---

## 🧪 Testing the Emails

### Test from Your Website:

1. **Make sure server is running:**
   ```bash
   cd server
   node server.js
   ```

2. **Fill out the booking form** on your website
3. **Submit the form**
4. **Check your inbox** at `info@taxiagadirairport.com`
5. **Also check customer's email** (the one you entered in the form)

### Expected Results:

✅ You should receive **2 emails** for each booking:
1. **Admin notification** (to info@taxiagadirairport.com)
2. **Customer confirmation** (to customer's email)

✅ For contact form:
1. **Contact message email** (to info@taxiagadirairport.com)

---

## 🔍 Troubleshooting

### Emails not sending?

1. **Check server console** for error messages
2. **Verify `.env` file** exists and has correct credentials
3. **Check SMTP settings** with your hosting provider
4. **Try port 465** if 587 doesn't work:
   ```env
   SMTP_PORT=465
   ```
5. **Check spam folder** in your email
6. **Verify email password** is correct

### Server Logs:

The server will show:
```
Attempting to send booking email to admin...
Booking email sent to admin successfully!
Attempting to send confirmation email to customer...
Confirmation email sent to customer successfully!
```

---

## 📱 Production Deployment

When deploying to your hosting:

1. **Upload server folder** to your hosting
2. **Create `.env` file** on server with your credentials
3. **Install dependencies:**
   ```bash
   npm install
   ```
4. **Start the server:**
   ```bash
   node server.js
   ```
   Or use PM2 for production:
   ```bash
   pm2 start server.js --name "taxi-email-server"
   ```

---

## 🎯 API Endpoints

Your server provides these endpoints:

- **POST** `/api/booking` - Booking form submission
- **POST** `/api/contact` - Contact form submission
- **GET** `/api/health` - Health check

---

## 📋 Security Notes

⚠️ **Important:**
- Never commit `.env` file to git
- Keep your email password secure
- `.env` is already in `.gitignore`

---

## ✨ Email Features Summary

✅ **Professional HTML Design**
✅ **Mobile Responsive**
✅ **Automatic Customer Confirmation**
✅ **Admin Notifications**
✅ **Clickable Phone & Email Links**
✅ **WhatsApp Integration**
✅ **Branded Colors & Logo**
✅ **Personalized Messages**
✅ **Action Required Alerts**
✅ **Complete Contact Information**

---

## 📞 Support

If you need help:
- Check server console logs
- Verify email credentials with Namecheap
- Test SMTP connection
- Review error messages

---

**Your email system is ready! Just add your credentials and start receiving beautifully designed emails.** 🚀

Last Updated: October 29, 2025

