# 🚀 Quick Upload Guide for Namecheap

## 📦 Just Upload These 7 Files!

```
✅ booking.php      (handles bookings)
✅ contact.php      (handles contact form)
✅ health.php       (health check)
✅ config.php       (configuration)
✅ test.php         (testing - optional)
✅ .htaccess        (Apache routing)
✅ .env             (email credentials - CREATE THIS!)
```

## 📍 Where to Upload

```
public_html/
└── api/  (or server/ or backend/)
    ├── booking.php
    ├── contact.php
    ├── health.php
    ├── config.php
    ├── test.php
    ├── .htaccess
    └── .env
```

## ⚙️ Before Uploading: Create .env

**Create file:** `server/.env`

```env
EMAIL_USER=info@taxiagadirairport.com
EMAIL_PASS=your_password_here
```

Replace `your_password_here` with your real email password!

## 🔒 Set Permissions After Upload

- All `.php` files: **644**
- `.htaccess`: **644**
- `.env`: **600** (restricted!)

## ✅ Test After Upload

Visit:
```
https://taxiagadirairport.com/api/test.php
https://taxiagadirairport.com/api/health
```

If you see JSON, it works! 🎉

## 🔧 Then Update Frontend

In `BookingForm.tsx` and `Contact.tsx`, change:

```javascript
// FROM:
'https://taxiagadir-production.up.railway.app/api/booking'

// TO:
'/api/booking'  // or your full domain
```

---

**That's it!** Your backend is now on PHP! 🚀

For detailed instructions, see: **UPLOAD_TO_NAMECHEAP.md**

