# PHP Server - Quick Start

## ✅ Conversion Complete!

Your Node.js server has been successfully converted to PHP.

## 📁 New Files

- **booking.php** - Handles booking form submissions
- **contact.php** - Handles contact form submissions
- **health.php** - Health check endpoint
- **config.php** - Configuration loader
- **.htaccess** - Apache routing rules
- **test.php** - Testing script
- **PHP_DEPLOYMENT_GUIDE.md** - Full deployment guide

## 🚀 Quick Setup

1. **Create `.env` file:**
   ```env
   EMAIL_USER=info@taxiagadirairport.com
   EMAIL_PASS=your_password
   ```

2. **Configure email** (see PHP_DEPLOYMENT_GUIDE.md)

3. **Upload files** to your hosting

4. **Test endpoints:**
   - `https://yourdomain.com/api/test.php`
   - `https://yourdomain.com/api/health`

## 📚 Documentation

For detailed instructions, see **PHP_DEPLOYMENT_GUIDE.md**

## 🔧 Key Changes

| Before (Node.js) | After (PHP) |
|-----------------|-------------|
| `server.js` | `booking.php`, `contact.php` |
| Nodemailer | PHP mail() |
| npm packages | No dependencies |
| Express.js | Apache + PHP |
| Railway/Vercel | Shared Hosting |

## ⚠️ Important Notes

1. The frontend still points to Railway URLs
2. Update `BookingForm.tsx` and `Contact.tsx` to use your domain
3. Test thoroughly before going live
4. Configure mail() function on your hosting

## 🆘 Need Help?

See the troubleshooting section in PHP_DEPLOYMENT_GUIDE.md
