# 🎯 START HERE - Upload to Namecheap

## ✅ Quick Answer: Upload ONLY These 7 Files

| File | Size | Purpose |
|------|------|---------|
| `booking.php` | 23 KB | Handles booking form |
| `contact.php` | 10 KB | Handles contact form |
| `health.php` | 0.2 KB | Health check |
| `config.php` | 1 KB | Configuration loader |
| `test.php` | 3 KB | Testing tool |
| `.htaccess` | 1 KB | Apache config |
| `.env` | 0.2 KB | **CREATE THIS** ⚠️ |

**Total: ~38 KB** - That's your entire backend!

---

## 📝 STEP 1: Create .env File

Create this file in the `server/` folder:

**File:** `server/.env`

```env
EMAIL_USER=info@taxiagadirairport.com
EMAIL_PASS=your_real_password_here
```

⚠️ **Important:** Replace `your_real_password_here` with your actual email password!

---

## 📁 STEP 2: Upload Structure

Upload to Namecheap like this:

```
public_html/
├── index.html (your React app)
├── assets/ (your React build)
└── api/  ← Create this folder
    ├── booking.php    ← Upload
    ├── contact.php    ← Upload
    ├── health.php     ← Upload
    ├── config.php     ← Upload
    ├── test.php       ← Upload (optional)
    ├── .htaccess      ← Upload
    └── .env           ← Upload (YOUR credentials!)
```

---

## 🔧 STEP 3: Set Permissions

After uploading in cPanel File Manager:

1. Right-click each file → "Change Permissions"
2. Set to:

| File Type | Permission |
|-----------|------------|
| All `.php` files | **644** |
| `.htaccess` | **644** |
| `.env` | **600** ← Very important! |

---

## ✅ STEP 4: Test

Visit these URLs:

```
https://taxiagadirairport.com/api/test.php
https://taxiagadirairport.com/api/health
```

If you see JSON responses → Success! 🎉

---

## 🔄 STEP 5: Update Frontend

Update these 2 files in your React app:

### BookingForm.tsx
Change line ~35-37:
```javascript
// FROM:
const apiUrl = 'https://taxiagadir-production.up.railway.app/api/booking';

// TO:
const apiUrl = '/api/booking';
// or
const apiUrl = 'https://taxiagadirairport.com/api/booking';
```

### Contact.tsx
Change line ~38-40:
```javascript
// FROM:
const apiUrl = 'https://taxiagadir-production.up.railway.app/api/contact';

// TO:
const apiUrl = '/api/contact';
// or
const apiUrl = 'https://taxiagadirairport.com/api/contact';
```

---

## 🚫 DO NOT Upload These

❌ **server.js** - This is the old Node.js file  
❌ **package.json** - Not needed  
❌ **node_modules/** - Not needed  
❌ **railway.json** - Not needed  
❌ **README.md** - Documentation only  
❌ **email-templates/** - Templates embedded in PHP  

**ONLY upload the 7 files listed above!**

---

## 📚 Need More Details?

- **Quick guide:** `QUICK_UPLOAD_GUIDE.md`
- **Full guide:** `UPLOAD_TO_NAMECHEAP.md`
- **Deployment:** `PHP_DEPLOYMENT_GUIDE.md`
- **Troubleshooting:** `PHP_DEPLOYMENT_GUIDE.md` (see Troubleshooting section)

---

## ✅ Checklist

Before going live:

- [ ] Created `.env` with real email credentials
- [ ] Uploaded all 7 files to `public_html/api/`
- [ ] Set `.php` files to 644 permissions
- [ ] Set `.env` to 600 permissions
- [ ] Tested `/api/test.php`
- [ ] Tested `/api/health`
- [ ] Updated BookingForm.tsx API URL
- [ ] Updated Contact.tsx API URL
- [ ] Tested booking form submission
- [ ] Tested contact form submission
- [ ] Received test emails

---

## 🆘 Troubleshooting

**"404 Not Found"**
→ Check file names are exact, files are in `api/` folder

**"500 Error"**
→ Check file permissions (should be 644)
→ Check PHP version (need 7.4+)

**"Emails not sending"**
→ Check `.env` has correct credentials
→ Contact Namecheap support about mail() configuration

---

**That's it! You're done!** 🚀

Your backend is now running on PHP - easy, cheap, and simple!

