<?php
// Load environment variables
if (file_exists(__DIR__ . '/.env')) {
    $lines = file(__DIR__ . '/.env', FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    foreach ($lines as $line) {
        if (strpos(trim($line), '#') === 0) {
            continue;
        }
        list($name, $value) = explode('=', $line, 2);
        $_ENV[trim($name)] = trim($value);
    }
}

// Email Configuration
// For PHP mail() function, these are informational only
// Actual SMTP settings should be configured in php.ini or via hosting panel
define('SMTP_HOST', $_ENV['SMTP_HOST'] ?? getenv('SMTP_HOST') ?: 'mail.taxiagadirairport.com');
define('SMTP_PORT', $_ENV['SMTP_PORT'] ?? getenv('SMTP_PORT') ?: 587);
define('EMAIL_USER', $_ENV['EMAIL_USER'] ?? getenv('EMAIL_USER') ?: 'info@taxiagadirairport.com');
define('EMAIL_PASS', $_ENV['EMAIL_PASS'] ?? getenv('EMAIL_PASS') ?: '');

// Validate required configuration
if (empty(EMAIL_USER)) {
    error_log('WARNING: Email user is not configured');
}
?>
