# 📧 Email Templates Documentation

This directory contains preview versions of the email templates used by Taxi Agadir Airport's booking and contact forms.

## 📬 Email Templates

### 1. **Booking Reservation Email** (`booking-email-preview.html`)
Sent when a customer submits a booking/reservation form.

**Features:**
- ✅ **Blue gradient header** with animated top border
- ✅ **Priority badge** - "URGENT - NOUVELLE RÉSERVATION"
- ✅ **Timestamp** - Shows when the email was received
- ✅ **Client Information Section**
  - Full name
  - Email (clickable mailto link)
  - Phone (clickable tel link)
  - Number of passengers
- ✅ **Trip Details Section**
  - Trip type badge (Round-trip in green / One-way in orange)
  - Departure location
  - Destination
  - Arrival date & time
  - Return date & time (if applicable)
  - Hotel name
- ✅ **Action Required Alert Box**
- ✅ **Professional footer** with complete contact information
- ✅ **Fully responsive** - Mobile-friendly design

**Color Scheme:**
- Header: Blue gradient (#0D47A1 → #1976D2)
- Accent: Orange (#FB8C00)
- Alert: Red priority badge (#FF5252)

---

### 2. **Contact Form Email** (`contact-email-preview.html`)
Sent when a customer submits the contact form.

**Features:**
- ✅ **Orange gradient header** with animated top border
- ✅ **Priority badge** - "NOUVEAU MESSAGE"
- ✅ **Timestamp** - Shows when the email was received
- ✅ **Contact Information Section**
  - Name
  - Email (clickable mailto link)
  - Phone (clickable tel link)
  - Subject (displayed as a blue badge)
- ✅ **Message Section**
  - Customer's message displayed in an orange-tinted box
  - Preserves line breaks and formatting
- ✅ **Action Required Alert Box**
- ✅ **Professional footer** with complete contact information
- ✅ **Fully responsive** - Mobile-friendly design

**Color Scheme:**
- Header: Orange gradient (#FB8C00 → #EF6C00)
- Accent: Blue (#0D47A1)
- Message box: Light orange gradient

---

## 🎨 Design Features

### Common Elements

1. **Gradient Backgrounds**
   - Headers use smooth, eye-catching gradients
   - Subtle gradients on info boxes for depth

2. **Priority Indicators**
   - Booking: Red "URGENT" badge
   - Contact: Blue "NOUVEAU MESSAGE" badge

3. **Timestamp Display**
   - Shows full date and time in French format
   - Example: "mercredi 29 janvier 2025 à 14:30:45"

4. **Responsive Design**
   - Stacks horizontally on mobile
   - Maintains readability on all screen sizes

5. **Interactive Elements**
   - Email links open default mail client
   - Phone links trigger dial on mobile devices
   - Hover effects on links

6. **Visual Hierarchy**
   - Clear section titles with emoji icons
   - Color-coded information (labels in brand colors, values in dark text)
   - Strategic use of bold and font sizes

7. **Professional Footer**
   - Company branding
   - Complete address
   - Multiple contact methods
   - Tagline: "Service Premium 24/7 - Transferts Aéroport & Navettes"

---

## 📱 Mobile Responsiveness

Both templates include media queries for screens under 600px:
- Containers adjust to full width
- Info rows stack vertically
- Padding optimized for mobile
- Labels take full width with values below

---

## 🔧 How to Preview

Simply open the HTML files in any modern web browser:

1. **Booking Email Preview:**
   ```
   server/email-templates/booking-email-preview.html
   ```

2. **Contact Email Preview:**
   ```
   server/email-templates/contact-email-preview.html
   ```

---

## 📝 Template Variables

### Booking Email
The actual email template in `server/server.js` uses these variables:
- `${fullname}` - Customer's full name
- `${email}` - Customer's email address
- `${phone}` - Customer's phone number
- `${passengers}` - Number of passengers
- `${tripType}` - Type of trip ('round-trip' or 'one-way')
- `${from}` - Departure location
- `${to}` - Destination
- `${arrivalDate}` - Arrival date/time
- `${returnDate}` - Return date/time (optional)
- `${address}` - Hotel name/address

### Contact Email
The actual email template in `server/server.js` uses these variables:
- `${name}` - Contact's name
- `${email}` - Contact's email address
- `${phone}` - Contact's phone number
- `${subject}` - Message subject
- `${message}` - Full message content

---

## 🚀 Implementation

These emails are automatically sent via Nodemailer when:
1. A customer submits the booking form → Booking email sent to `info@taxiagadirairport.com`
2. A customer submits the contact form → Contact email sent to `info@taxiagadirairport.com`

The server automatically includes:
- Current timestamp in French format
- Reply-To header set to customer's email
- Proper UTF-8 encoding
- HTML mime type

---

## ✨ Best Practices

✅ **Fast Action Required**
- Both emails emphasize urgent response needed
- Clear call-to-action in alert boxes

✅ **Professional Appearance**
- Clean, modern design
- Consistent branding (colors match website)
- High-quality typography

✅ **Email Client Compatibility**
- Inline CSS for maximum compatibility
- Table-free layout (flexbox with fallbacks)
- Tested on major email clients

✅ **Accessibility**
- High contrast text
- Semantic HTML structure
- Clear visual hierarchy

---

## 📞 Contact Information Displayed

**Address:**
N˚ 07- Bloc A- Complexe TIVOLI - Secteur Balnéaire
80010 - Agadir - Maroc

**Phone:**
+212 608 003 030
+212 661 444 189

**Email:**
info@taxiagadirairport.com

---

**Last Updated:** October 29, 2025
**Version:** 2.0 - Enhanced Design with Modern UI

