<?php
/**
 * Test script to verify PHP server setup
 * Visit: https://yourdomain.com/api/test.php
 */

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

$results = [
    'php_version' => phpversion(),
    'server_info' => $_SERVER['SERVER_SOFTWARE'] ?? 'Unknown',
    'timestamp' => date('c'),
    'checks' => []
];

// Check PHP version
$results['checks']['php_version'] = [
    'status' => version_compare(PHP_VERSION, '7.4.0', '>=') ? 'pass' : 'fail',
    'message' => 'PHP ' . PHP_VERSION . (version_compare(PHP_VERSION, '7.4.0', '>=') ? ' (OK)' : ' (Upgrade needed)')
];

// Check if mail function is available
$results['checks']['mail_function'] = [
    'status' => function_exists('mail') ? 'pass' : 'fail',
    'message' => function_exists('mail') ? 'Mail function available' : 'Mail function not available'
];

// Check if .htaccess is working
$results['checks']['mod_rewrite'] = [
    'status' => !empty($_SERVER['REQUEST_URI']) ? 'pass' : 'warn',
    'message' => 'mod_rewrite status unknown (check .htaccess)'
];

// Check if config.php can be loaded
try {
    require_once __DIR__ . '/config.php';
    $results['checks']['config'] = [
        'status' => defined('EMAIL_USER') ? 'pass' : 'fail',
        'message' => defined('EMAIL_USER') ? 'Config loaded successfully' : 'Config file issues'
    ];
} catch (Exception $e) {
    $results['checks']['config'] = [
        'status' => 'fail',
        'message' => 'Config file error: ' . $e->getMessage()
    ];
}

// Check if .env file exists
$results['checks']['env_file'] = [
    'status' => file_exists(__DIR__ . '/.env') ? 'pass' : 'warn',
    'message' => file_exists(__DIR__ . '/.env') ? '.env file exists' : '.env file not found (optional)'
];

// Check directory permissions
$results['checks']['permissions'] = [
    'status' => is_readable(__DIR__) ? 'pass' : 'fail',
    'message' => is_readable(__DIR__) ? 'Directory readable' : 'Directory not readable'
];

// Check if booking.php exists
$results['checks']['booking_endpoint'] = [
    'status' => file_exists(__DIR__ . '/booking.php') ? 'pass' : 'fail',
    'message' => file_exists(__DIR__ . '/booking.php') ? 'booking.php found' : 'booking.php not found'
];

// Check if contact.php exists
$results['checks']['contact_endpoint'] = [
    'status' => file_exists(__DIR__ . '/contact.php') ? 'pass' : 'fail',
    'message' => file_exists(__DIR__ . '/contact.php') ? 'contact.php found' : 'contact.php not found'
];

// Check if health.php exists
$results['checks']['health_endpoint'] = [
    'status' => file_exists(__DIR__ . '/health.php') ? 'pass' : 'fail',
    'message' => file_exists(__DIR__ . '/health.php') ? 'health.php found' : 'health.php not found'
];

// Overall status
$allPassed = true;
foreach ($results['checks'] as $check) {
    if ($check['status'] === 'fail') {
        $allPassed = false;
        break;
    }
}

$results['overall_status'] = $allPassed ? 'pass' : 'fail';
$results['message'] = $allPassed 
    ? '✅ All checks passed! Your PHP server is configured correctly.'
    : '⚠️ Some checks failed. Review the details above.';

echo json_encode($results, JSON_PRETTY_PRINT);
?>
